AdditionalContractLoadSettingsEvent = {};
AdditionalContractLoadSettingsEvent_mt = Class(AdditionalContractLoadSettingsEvent, Event);
InitEventClass(AdditionalContractLoadSettingsEvent, "AdditionalContractLoadSettingsEvent");

AdditionalContractLoadSettingsEvent.NUM_BITS_SETTINGS_SUCCESSFACTOR = 1;

---Create instance of Event class
function AdditionalContractLoadSettingsEvent.emptyNew()
    local self = Event.new(AdditionalContractLoadSettingsEvent_mt);
    return self;
end;

---Create new instance of event
function AdditionalContractLoadSettingsEvent.new(successFactor)
    local self = AdditionalContractLoadSettingsEvent.emptyNew();
    self.successFactor = successFactor;
    return self;
end;

---Called on client side on join
function AdditionalContractLoadSettingsEvent:readStream(streamId, connection)
    if g_server == nil then
        self.successFactor = streamReadInt8(streamId, AdditionalContractLoadSettingsEvent.NUM_BITS_SETTINGS_SUCCESSFACTOR);
        
        self:run(connection);
    end;
end;

---Called on server side on join
function AdditionalContractLoadSettingsEvent:writeStream(streamId, connection)
	if g_additionalContractTypes.settings["additionalContract_successFactor"] ~= nil then
		streamWriteInt8(streamId, g_additionalContractTypes.settings["additionalContract_successFactor"], AdditionalContractLoadSettingsEvent.NUM_BITS_SETTINGS_SUCCESSFACTOR);
	end;	
end;

---Run action on receiving side
function AdditionalContractLoadSettingsEvent:run(connection)
	if g_server ~= nil then
		g_server:broadcastEvent(AdditionalContractLoadSettingsEvent.new(g_additionalContractTypes.settings["additionalContract_successFactor"]), false);				
		return;
	end;	
	if self.successFactor ~= nil then
		g_additionalContractTypes:setSuccessFactor(self.successFactor);			
	end;
end;


