MulcherChangeSettingsEvent = {};
MulcherChangeSettingsEvent_mt = Class(MulcherChangeSettingsEvent, Event);
InitEventClass(MulcherChangeSettingsEvent, "MulcherChangeSettingsEvent");

MulcherChangeSettingsEvent.NUM_BITS_SETTINGS_ID = 1;
MulcherChangeSettingsEvent.NUM_BITS_STATE = 2;

---Create instance of Event class
-- @return table self instance of class event
function MulcherChangeSettingsEvent.emptyNew()
    local self = Event.new(MulcherChangeSettingsEvent_mt);
    return self;
end;

---Create new instance of event
-- @param table object object
-- @param string, string
function MulcherChangeSettingsEvent.new(settingsId, settingsState)
    local self = MulcherChangeSettingsEvent.emptyNew();
    self.settingsId = settingsId;
    self.settingsState = tostring(settingsState);	
    return self;
end;

---Called on client side on join
-- @param string streamId streamId
-- @param string connection connection
function MulcherChangeSettingsEvent:readStream(streamId, connection)
    self.settingsId = streamReadString(streamId, MulcherChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    self.settingsState = streamReadString(streamId, MulcherChangeSettingsEvent.NUM_BITS_STATE);
    self:run(connection);
end;

---Called on server side on join
-- @param string streamId streamId
-- @param string connection connection
function MulcherChangeSettingsEvent:writeStream(streamId, connection)
    streamWriteString(streamId, self.settingsId, MulcherChangeSettingsEvent.NUM_BITS_SETTINGS_ID);
    streamWriteString(streamId, self.settingsState, MulcherChangeSettingsEvent.NUM_BITS_STATE);
end;

---Run action on receiving side
-- @param string connection connection
function MulcherChangeSettingsEvent:run(connection)	
	if self.settingsId == "mulcherMission_minMax" then
		g_additionalContractTypes:getTyp("mulcherMission"):setMaxNumInstance(g_additionalContractUtils:getTypToString(self.settingsState));
	end;	
    if g_server ~= nil then
        g_server:broadcastEvent(self, false);
    end;
end;

