-- Author: ALXXA
-- Date: 27.08.2025
-- Version: 1.0.0.7

FlashlightImproved = {}

local Flashlight, specFlashlight

local mountFlashlight, spec

local headFlashlight, specHead

local headNode, spineNode, playerModel

local flashlightTextVisibility = true

local flashlightOnLoad = false
local mountFlashlightOnLoad = false
local headFlashlightOnLoad = false

local changeSexFlashlight = false
local changeSexMountFlashlight = false
local changeSexHeadFlashlight = false

local modDir = g_currentModDirectory
local headflashlightXmlFile = modDir.."headflashlight.xml"
local mountflashlightXmlFile = modDir.."neckflashlight.xml"
local flashlightXmlFile = modDir.."flashlight.xml"

local translate = 0


function FlashlightImproved:loadMap(savegame)

	local storeImage = modDir.."store_flashlight.dds" 
	g_storeManager.categoryByName.FLASHLIGHTS.image = storeImage
	
	
end


function FlashlightImproved:MountFlashlightRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)

	if not g_localPlayer.isOwner then return end
	
	g_inputBinding:beginActionEventsModification(PlayerInputComponent.INPUT_CONTEXT_NAME)
	
	_, g_localPlayer.inputComponent.toggleMountFlashlightId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_MountFLASHLIGHT, self, FlashlightImproved.updateMountFlashlightActionEvent, false, true, false, true)
	g_inputBinding:setActionEventText(g_localPlayer.inputComponent.toggleMountFlashlightId, g_i18n:getText("on_TOGGLE_MountFLASHLIGHT"))

	_, g_localPlayer.inputComponent.translateUpMountFlashlightId = g_inputBinding:registerActionEvent(InputAction.TRANSLATEUP_MountFLASHLIGHT, self, FlashlightImproved.TranslateUpMountFlashlight, false,  true, true, true)
	g_inputBinding:setActionEventTextVisibility(g_localPlayer.inputComponent.translateUpMountFlashlightId, false)
	_, g_localPlayer.inputComponent.translateDownMountFlashlightId = g_inputBinding:registerActionEvent(InputAction.TRANSLATEDOWN_MountFLASHLIGHT, self, FlashlightImproved.TranslateDownMountFlashlight, false, true, true, true)
	g_inputBinding:setActionEventTextVisibility(g_localPlayer.inputComponent.translateDownMountFlashlightId, false)
		
 	g_inputBinding:endActionEventsModification()
end

function FlashlightImproved:HeadFlashlightRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)

	if not g_localPlayer.isOwner then return end
	
	g_inputBinding:beginActionEventsModification(PlayerInputComponent.INPUT_CONTEXT_NAME)	
	
	_, g_localPlayer.inputComponent.toggleHeadFlashlightId = g_inputBinding:registerActionEvent(InputAction.TOGGLE_HeadFLASHLIGHT, self, FlashlightImproved.updateHeadFlashlightActionEvent, false, true, false, true)
	g_inputBinding:setActionEventText(g_localPlayer.inputComponent.toggleHeadFlashlightId, g_i18n:getText("on_TOGGLE_HeadFLASHLIGHT"))

 	g_inputBinding:endActionEventsModification()
end


function FlashlightImproved:unregisterActionEvents(id)

	if not g_localPlayer.isOwner then return end	

	g_inputBinding:beginActionEventsModification(PlayerInputComponent.INPUT_CONTEXT_NAME)	
	g_inputBinding:removeActionEvent(id)
 	g_inputBinding:endActionEventsModification()
end


function FlashlightImproved:updateMountFlashlightActionEvent()

	if not g_localPlayer.getIsInVehicle() and g_localPlayer.inputComponent.toggleMountFlashlightId ~= nil then	
	
		if spec.isActive then spec.isActive = false else spec.isActive = true end
	
		if spec.isActive then 
			g_inputBinding:setActionEventText(g_localPlayer.inputComponent.toggleMountFlashlightId, g_i18n:getText("off_TOGGLE_MountFLASHLIGHT")) 
		else 
			g_inputBinding:setActionEventText(g_localPlayer.inputComponent.toggleMountFlashlightId, g_i18n:getText("on_TOGGLE_MountFLASHLIGHT"))
		end 

		if spec.lightNode ~= nil then setVisibility(spec.lightNode, spec.isActive) end
		if spec.lightMeshNode ~= nil then setVisibility(spec.lightMeshNode, spec.isActive) end	

		if spec.samples ~= nil then if not g_soundManager:getIsSamplePlaying(spec.samples.toggle) then g_soundManager:playSample(spec.samples.toggle) end end	
		
	end
end


function FlashlightImproved:TranslateUpMountFlashlight()

	if translate < 0.045 then 
		translate = translate + 0.001
		setTranslation(mountFlashlight.graphicalNode, translate, 0, 0)
	end
end


function FlashlightImproved:TranslateDownMountFlashlight()

	if translate > -0.022 then
		translate = translate - 0.001
		setTranslation(mountFlashlight.graphicalNode, translate, 0, 0)
	end
end


function FlashlightImproved:updateHeadFlashlightActionEvent()

	if not g_localPlayer.getIsInVehicle() and g_localPlayer.inputComponent.toggleHeadFlashlightId ~= nil then	

		if specHead.isActive then specHead.isActive = false else specHead.isActive = true end
	
		if specHead.isActive then 
			g_inputBinding:setActionEventText(g_localPlayer.inputComponent.toggleHeadFlashlightId, g_i18n:getText("off_TOGGLE_HeadFLASHLIGHT")) 
		else 
			g_inputBinding:setActionEventText(g_localPlayer.inputComponent.toggleHeadFlashlightId, g_i18n:getText("on_TOGGLE_HeadFLASHLIGHT"))
		end 

		if specHead.lightNode ~= nil then setVisibility(specHead.lightNode, specHead.isActive) end
		if specHead.lightMeshNode ~= nil then setVisibility(specHead.lightMeshNode, specHead.isActive) end

		if specHead.samples ~= nil then if not g_soundManager:getIsSamplePlaying(specHead.samples.toggle) then g_soundManager:playSample(specHead.samples.toggle) end end	
		
	end
end


function FlashlightImproved:update(dt)

	if playerModel == nil then playerModel = g_localPlayer.graphicsComponent.model.i3dFilename end

	if playerModel ~= g_localPlayer.graphicsComponent.model.i3dFilename then
		
		if Flashlight ~= nil and Flashlight.rootNode ~= nil then		
			unlink(Flashlight.rootNode)			
			FlashlightIsPresent = false
			changeSexFlashlight = true
		end
		
		if mountFlashlight ~= nil and mountFlashlight.graphicalNode ~= nil and mountFlashlight.rootNode ~= nil then				
			unlink(mountFlashlight.graphicalNode)
			unlink(mountFlashlight.rootNode)
			mountFlashlightIsPresent = false
			changeSexMountFlashlight = true
		end
		
		if  headFlashlight ~= nil and specHead.lightNode ~= nil and headFlashlight.rootNode ~= nil and headFlashlight.graphicalNode ~= nil then
			unlink(specHead.lightNode)
			unlink(headFlashlight.graphicalNode)					
			unlink(headFlashlight.rootNode)			
			headFlashlightIsPresent = false
			changeSexHeadFlashlight = true
		end
	
		playerModel = g_localPlayer.graphicsComponent.model.i3dFilename 				
	end

	if g_localPlayer.graphicsComponent.model.thirdPersonHeadNode ~= nil then headNode = g_localPlayer.graphicsComponent.model.thirdPersonHeadNode else headNode = nil end
	if g_localPlayer.graphicsComponent.model.thirdPersonSpineNode ~= nil then spineNode = g_localPlayer.graphicsComponent.model.thirdPersonSpineNode else spineNode = nil end

	if not g_localPlayer.isOwner or headNode == nil or spineNode == nil then
		return false
	end

	local FlashlightIsPresent = false
	local mountFlashlightIsPresent = false
	local headFlashlightIsPresent = false
	
	for _, carriedHandTool in pairs(g_localPlayer.carriedHandTools) do		
	
		if carriedHandTool ~= nil and carriedHandTool.configFileName == "data/handTools/brandless/flashlight/flashlight.xml" then carriedHandTool:delete() end

		if carriedHandTool ~= nil and carriedHandTool.configFileName == flashlightXmlFile and not flashlightOnLoad then

			Flashlight = carriedHandTool
			specFlashlight = Flashlight.spec_flashlight
			
			Flashlight.shouldLockFirstPerson = nil			
					
			Flashlight:detachTool()
			Flashlight:attachTool()
			
			flashlightOnLoad = true
		end
		
		if carriedHandTool ~= nil and carriedHandTool.configFileName == flashlightXmlFile and not changeSexFlashlight then
			Flashlight.isFlashlight = true
			FlashlightIsPresent = true
		end
		
		if carriedHandTool ~= nil and carriedHandTool.configFileName == mountflashlightXmlFile and not mountFlashlightOnLoad then 

			mountFlashlight = carriedHandTool			
			spec = mountFlashlight.spec_flashlight	
			
			mountFlashlight.shouldLockFirstPerson = nil
			mountFlashlight.isFlashlight = false			
			mountFlashlight.isPlayerStartHandTool = true
			
			mountFlashlight.attachTool = Utils.overwrittenFunction(mountFlashlight.attachTool, FlashlightImproved.mountFlashlightAttachTool)
			mountFlashlight.detachTool = Utils.overwrittenFunction(mountFlashlight.detachTool, FlashlightImproved.mountFlashlightDetachTool)
			mountFlashlight.stopHolding = Utils.overwrittenFunction(mountFlashlight.stopHolding, FlashlightImproved.stopHolding)
						
			mountFlashlight:startHolding()
			
			if g_localPlayer.inputComponent.toggleMountFlashlightId == nil then FlashlightImproved:MountFlashlightRegisterActionEvents() end		

			mountFlashlightOnLoad = true
		end			

		if carriedHandTool ~= nil and carriedHandTool.configFileName == headflashlightXmlFile and not headFlashlightOnLoad then 			
			
			headFlashlight = carriedHandTool			
			specHead = headFlashlight.spec_flashlight	
			
			headFlashlight.shouldLockFirstPerson = nil
			headFlashlight.isFlashlight = false
			headFlashlight.isPlayerStartHandTool = true
		
			headFlashlight.attachTool = Utils.overwrittenFunction(headFlashlight.attachTool, FlashlightImproved.headFlashlightAttachTool)
			headFlashlight.detachTool = Utils.overwrittenFunction(headFlashlight.detachTool, FlashlightImproved.headFlashlightDetachTool)
			headFlashlight.stopHolding = Utils.overwrittenFunction(headFlashlight.stopHolding, FlashlightImproved.stopHolding)
						
			headFlashlight:startHolding()
			
			if g_localPlayer.inputComponent.toggleHeadFlashlightId == nil then FlashlightImproved:HeadFlashlightRegisterActionEvents() end		
			
			headFlashlightOnLoad = true
		end				

		if carriedHandTool ~= nil and carriedHandTool.configFileName == mountflashlightXmlFile and not changeSexMountFlashlight then mountFlashlightIsPresent = true end

		if carriedHandTool ~= nil and carriedHandTool.configFileName == headflashlightXmlFile and headFlashlightOnLoad and not changeSexHeadFlashlight then					
			
			if headNode ~= nil and g_localPlayer.camera.pitchNode ~= nil and specHead ~= nil then			
				if  g_localPlayer.graphicsState.isFirstPerson ~= nil and g_localPlayer.graphicsState.isFirstPerson then												
					setRotation(specHead.lightNode, 3.14, 0, -0.349)
					link(g_localPlayer.camera.pitchNode, specHead.lightNode)
				end				
				if  g_localPlayer.graphicsState.isFirstPerson ~= nil and not g_localPlayer.graphicsState.isFirstPerson then							
					setRotation(specHead.lightNode, -1.57, 0, -0.349)
					link(headNode, specHead.lightNode)						
				end
			end	
	
			headFlashlightIsPresent = true					
		end		
	end

	if (mountFlashlightOnLoad or headFlashlightOnLoad) and flashlightOnLoad then
		if g_localPlayer.currentHandTool.configFileName == mountflashlightXmlFile or g_localPlayer.currentHandTool.configFileName == headflashlightXmlFile then
			g_inputBinding:setActionEventTextVisibility(g_localPlayer.inputComponent.toggleFlashlightId, false)
			flashlightTextVisibility = false
			FlashlightIsPresent = false
			Flashlight.isFlashlight = false
		end
	end

	if not flashlightTextVisibility and FlashlightIsPresent then					
		g_inputBinding:setActionEventTextVisibility(g_localPlayer.inputComponent.toggleFlashlightId, true)
		flashlightTextVisibility = true						
	end

	if flashlightTextVisibility and not FlashlightIsPresent then 
 		
		Flashlight = nil

		g_inputBinding:setActionEventTextVisibility(g_localPlayer.inputComponent.toggleFlashlightId, false)
		flashlightTextVisibility = false
		flashlightOnLoad = false
		changeSexFlashlight = false
	end	

	if g_localPlayer.inputComponent.toggleMountFlashlightId ~= nil and not mountFlashlightIsPresent then 

		if spec ~= nil and mountFlashlight ~= nil and not changeSexMountFlashlight then
			if spec.lightNode ~= nil and spec.lightMeshNode ~= nil and mountFlashlight.graphicalNode ~= nil and mountFlashlight.rootNode ~= nil then
				spec.isActive = false
				setVisibility(spec.lightNode, false)
				setVisibility(spec.lightMeshNode, false)
				setVisibility(mountFlashlight.graphicalNode, false)		
				unlink(mountFlashlight.graphicalNode)
				unlink(mountFlashlight.rootNode)
			end
		end

		mountFlashlight	= nil	

		if not changeSexMountFlashlight then
			FlashlightImproved:unregisterActionEvents(g_localPlayer.inputComponent.toggleMountFlashlightId)
			FlashlightImproved:unregisterActionEvents(g_localPlayer.inputComponent.translateUpMountFlashlightId)
			FlashlightImproved:unregisterActionEvents(g_localPlayer.inputComponent.translateDownMountFlashlightId)
			g_localPlayer.inputComponent.toggleMountFlashlightId = nil 
			g_localPlayer.inputComponent.translateUpMountFlashlightId = nil
			g_localPlayer.inputComponent.translateDownMountFlashlightId = nil
		end
		mountFlashlightOnLoad = false
		changeSexMountFlashlight = false
	end

	if g_localPlayer.inputComponent.toggleHeadFlashlightId ~= nil and not headFlashlightIsPresent then 

		if specHead ~= nil and headFlashlight ~= nil and not changeSexHeadFlashlight then
			if specHead.lightNode ~= nil and specHead.lightMeshNode ~= nil and headFlashlight.graphicalNode ~= nil and headFlashlight.rootNode ~= nil then
				specHead.isActive = false
				setVisibility(specHead.lightNode, false)
				setVisibility(specHead.lightMeshNode, false)
				setVisibility(headFlashlight.graphicalNode, false)
				unlink(specHead.lightNode)
				unlink(headFlashlight.graphicalNode)					
				unlink(headFlashlight.rootNode)
			end
		end

		headFlashlight	= nil			

		if not changeSexHeadFlashlight then 
			FlashlightImproved:unregisterActionEvents(g_localPlayer.inputComponent.toggleHeadFlashlightId)
			g_localPlayer.inputComponent.toggleHeadFlashlightId = nil 		
		end
		headFlashlightOnLoad = false
		changeSexHeadFlashlight = false
	end	
end


function FlashlightImproved:mountFlashlightAttachTool()

	if mountFlashlight.graphicalNode ~= nil and headNode ~= nil then link(headNode, mountFlashlight.graphicalNode) end
	if mountFlashlight.graphicalNode ~= nil then setVisibility(mountFlashlight.graphicalNode, true) end
			
	if mountFlashlight.rootNode ~= nil and mountFlashlight.firstPersonNode ~= nil and g_localPlayer.camera.pitchNode ~= nil then 
		HandToolUtil.linkAndTransformRelativeToParent(mountFlashlight.rootNode, mountFlashlight.firstPersonNode, g_localPlayer.camera.pitchNode)		
		setVisibility(mountFlashlight.rootNode, true)		
	end
end


function FlashlightImproved:mountFlashlightDetachTool()        
	
	if mountFlashlight ~= nil and mountFlashlight.graphicalNode ~= nil then
		setVisibility(mountFlashlight.graphicalNode, false) 
		unlink(mountFlashlight.graphicalNode)
	end
	
	if mountFlashlight ~= nil and mountFlashlight.rootNode ~= nil then    
		setVisibility(mountFlashlight.rootNode, false)
		unlink(mountFlashlight.rootNode)
	end	
end


function FlashlightImproved:headFlashlightAttachTool()

	if headFlashlight.graphicalNode ~= nil and headNode ~= nil then link(headNode, headFlashlight.graphicalNode) end
	if headFlashlight.graphicalNode ~= nil then setVisibility(headFlashlight.graphicalNode, true) end
			
	if headFlashlight.rootNode ~= nil and headFlashlight.firstPersonNode ~= nil and g_localPlayer.camera.pitchNode ~= nil then 
		HandToolUtil.linkAndTransformRelativeToParent(headFlashlight.rootNode, headFlashlight.firstPersonNode, g_localPlayer.camera.pitchNode)		
		setVisibility(headFlashlight.rootNode, true)		
	end
end


function FlashlightImproved:headFlashlightDetachTool()
        
	if specHead ~= nil then	unlink(specHead.lightNode) end
	
	if headFlashlight ~= nil and headFlashlight.graphicalNode ~= nil then
		setVisibility(headFlashlight.graphicalNode, false) 
		unlink(headFlashlight.graphicalNode)
	end
	
	if headFlashlight ~= nil and headFlashlight.rootNode ~= nil then    
		setVisibility(headFlashlight.rootNode, false)
		unlink(headFlashlight.rootNode)
	end	
end


function FlashlightImproved:stopHolding()
end

function BuyHandToolData:buy(callback, callbackTarget, callbackArguments)

	local storeItem = self.storeItem 
	local xmlFilename = storeItem.xmlFilename
	local farmId = g_currentMission:getFarmId() 
	
	if storeItem ~= nil and xmlFilename ~= nil and farmId ~= nil then	
		if g_currentMission:getNumOfItems(storeItem, farmId) >= 1 and (xmlFilename == flashlightXmlFile or xmlFilename == mountflashlightXmlFile or xmlFilename == headflashlightXmlFile) then 
			InfoDialog.show(g_i18n:getText("warning_tooManyPlaceables"), nil, nil, DialogElement.TYPE_WARNING)	
			return false
		end
	end
	
    local data = HandToolLoadingData.new()
    data:setStoreItem(self.storeItem)
    data:setOwnerFarmId(self.ownerFarmId)
    data:setHolder(self.holder)
    data:load(self.onBought, self, {callback=callback, callbackTarget=callbackTarget, callbackArguments=callbackArguments})
end


addModEventListener(FlashlightImproved)